/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.item;

import de.unhappycodings.quarry.Quarry;
import de.unhappycodings.quarry.common.blocks.QuarryBlock;
import de.unhappycodings.quarry.common.container.AreaCardContainer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AreaCardItem
extends Item
implements MenuProvider {
    public AreaCardItem() {
        super(new Item.Properties().m_41487_(1).m_41491_(Quarry.creativeTab));
    }

    public static void writePos(CompoundTag nbt, BlockPos pos) {
        nbt.m_128405_("x", pos.m_123341_());
        nbt.m_128405_("y", pos.m_123342_());
        nbt.m_128405_("z", pos.m_123343_());
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        String pos;
        if (stack.m_41784_().m_128441_("pos1")) {
            pos = stack.m_41784_().m_128423_("pos1").m_7916_().replace("{", "").replace("}", "").replace(",", " ");
            tooltipComponents.add((Component)Component.m_237115_((String)"item.quarry.areacard.text.box").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
            if (stack.m_41784_().m_128441_("lastBlock")) {
                int blocksMined = stack.m_41784_().m_128451_("lastBlock");
                tooltipComponents.add((Component)Component.m_237115_((String)"item.quarry.areacard.text.mined").m_130946_(" " + blocksMined).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
            }
            tooltipComponents.add((Component)Component.m_237115_((String)"item.quarry.areacard.text.from").m_130946_(" " + pos).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
        }
        if (stack.m_41784_().m_128441_("pos2")) {
            pos = stack.m_41784_().m_128423_("pos2").m_7916_().replace("{", "").replace("}", "").replace(",", " ");
            tooltipComponents.add((Component)Component.m_237115_((String)"item.quarry.areacard.text.to").m_130946_(" " + pos).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
        }
        for (int i = 0; i <= 6; ++i) {
            if (!stack.m_41784_().m_128469_("Filters").m_128471_(String.valueOf(i))) continue;
            tooltipComponents.add((Component)Component.m_237115_((String)"item.quarry.areacard.text.filters_active").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
            break;
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        Player player = context.m_43723_();
        ItemStack item = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof QuarryBlock || context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.CONSUME;
        }
        if (!item.m_41784_().m_128441_("pos1") || item.m_41784_().m_128441_("pos2")) {
            item = new ItemStack((ItemLike)item.m_41720_());
            CompoundTag posTag = new CompoundTag();
            AreaCardItem.writePos(posTag, pos);
            item.m_41784_().m_128365_("pos1", (Tag)posTag);
            player.m_213846_((Component)Component.m_237115_((String)"message.quarry.savedfirst").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
        } else if (!item.m_41784_().m_128441_("pos2")) {
            CompoundTag posTag = new CompoundTag();
            AreaCardItem.writePos(posTag, pos);
            item.m_41784_().m_128365_("pos2", (Tag)posTag);
            player.m_213846_((Component)Component.m_237115_((String)"message.quarry.savedsecond").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
        }
        player.m_8061_(EquipmentSlot.MAINHAND, item);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (!pLevel.f_46443_ && pUsedHand == InteractionHand.MAIN_HAND) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)this);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"Area Card");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new AreaCardContainer(pContainerId, pPlayerInventory, pPlayer.m_20097_(), pPlayer.m_9236_());
    }
}

